﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 9 : Les principes du concept objet
# Projet  : Portfolio Multimédia
# Fichier : ProjetChapitre9.fla
# Classe  : Item.as
#
*/

//Définition de la classe Item
class Item extends MovieClip{

 private var info:Array;
 private var cetItem:MovieClip;
 private static var  vitesseItem:Number = 12;
  
 public function afficher(yMax:Number):Void {  
  cetItem._visible=true;
  cetItem.onEnterFrame = function():Void {
     this._y +=vitesseItem ;
     if (this._y >=  yMax) {
         this._y =  yMax;
	 delete this.onEnterFrame;
     }
   }
 }

 public function effacer(yMin:Number):Void { 
  cetItem.onEnterFrame = function():Void {
     this._y -=vitesseItem ;
     if (this._y <=  yMin) {
	 this._y = yMin;                      
	 delete this.onEnterFrame;
         this._visible = false;
     }
   }
 }

 // Déterminer le chemin d'accès aux photos
 function setCheminPhoto(l:Array):String {
   return "../"+l[0]+"/"+l[1]+"/";
 }


 public function Item(nom:String, cible:MovieClip, profondeur:Number, x:Number, y:Number,  l:Array) {

   cetItem = cible.attachMovie("ItemMenuClp", nom+profondeur, profondeur);
   cetItem._x = x;
   cetItem._y = y;
   cetItem._visible = false;
   cetItem.chemin = setCheminPhoto(l);
   cetItem.label = l[1];
   cetItem.labelOut.text=l[1];
   cetItem.nbElt = l[2];


   var bNav:BarreNavigation;
   cetItem.onRollOver = function():Void {
     this._alpha = 40;
   };

   cetItem.onRollOut = function():Void {
     this._alpha = 100;
   };

   cetItem.onPress = function():Void {
     // Afficher la barre de navigation correspondant à l'item sélectionné
     bNav = new BarreNavigation(_global.FdNav, _global.niveauNavigation+1,  0, 0, this.chemin, this.nbElt, this.label);
     // Afficher la première photo correspondant à l'item sélectionné
     _global.FdPho.loadMovie(this.chemin+this.label+"0.jpg");
   };

 }

}
 
